<?php

namespace App\Models\Trajet;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Trajet extends Model 
{

    protected $table = 'trajets';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function type_trajet()
    {
        return $this->belongsTo('App\Models\TypeTrajet\TypeTrajet');
    }

    public function commandes()
    {
        return $this->hasMany('App\Models\Commandes\Commande');
    }

}